C
C  tfit7.f
C
C     Function Fitting with Ordering Selection by AIC
C
C--------------------------------------------------------------------
C     References :
C     Kitagawa, G., FORTRAN77 Programming for Time Series Analysis,
C       Iwanami, Tokyo, 1993, Chap.5 (in Japanese)
C
C     Togawa, H. and Arisawa, M. (ed.), The toolbox of algorithms,
C       Science-Sha, Tokyo, 2000, Chap.4 (in Japanese)
C
C---+-^--1----+----2----+----3----+----4----+----5----+----6----+----7-
C
      SUBROUTINE TFIT7(NPOINT,NFUNC,DAT,IDX1,F,C,VFIT,NORDER,AICMIN)
      IMPLICIT REAL*8 (A-H,O-Z)
C
      LOGICAL*1 IDX1,LOGI1
      INTEGER*4 MF,M1,M2
C
      PARAMETER(NMAX=200)
      PARAMETER(MAXF=50)
C
      DIMENSION F(NMAX,MAXF)
      DIMENSION X(NMAX,MAXF)
      DIMENSION TINV(MAXF,MAXF)
C
      DIMENSION DAT(NMAX)
      DIMENSION VFIT(NMAX)
      DIMENSION C(MAXF)
      DIMENSION VEC(MAXF)
C
      DIMENSION MF(MAXF)
      DIMENSION M1(MAXF)
      DIMENSION M2(MAXF)
C
      DIMENSION IDX1(NMAX)
C
      EPS=1.0D-10
      NDIM0=NFUNC*2+2
C     NDIM1=NORDER*2+2+1
C
C     PI=ATAN(1.0D0)*4.0D0
      PI=3.1415926535897932385
C
C	PRINT *,'TFIT7: VALUES INITIALIZATION'
C---- Value Initialization
C
 5555 CONTINUE
      DO I=1,NDIM0+2
       C(I)=0.0
       MF(I)=0
       M1(I)=0
       M2(I)=0
       DO J=1,NDIM0+2
        TINV(I,J)=0.0
       ENDDO
       VEC(I)=0.0
      ENDDO
      DO I=1,NPOINT
       VFIT(I)=0.0
      ENDDO
C
C---- Enter Loop
C
      ND=0
      LOGI1=.TRUE.
      NCOUNT=0
      AICMIN=9.9D9
      AIC=0.0
      NAIC=0
C
C---- Generate Configuration
C
 1000 CONTINUE
       LOGI1=.FALSE.
       DO WHILE (MF(ND+1).LT.NORDER)
        ND=ND+1
        MF(ND+1)=MF(ND)+1
       ENDDO
       NCOUNT=NCOUNT+1
       IF (ND.LE.0.OR.ND.GT.MAXF) GOTO 8000
       DO I=1,ND
        M1(I)=MF(I+1)
       ENDDO
C      WRITE (*,*) NCOUNT,ND," : ",(M1(I),I=1,ND)
C
C	PRINT *,'TFIT7: MATRIX INITIALIZATION'
C---- Matrix Initialization
C
       DO I=1,NDIM0
        DO J=1,NPOINT
         X(J,I)=0.0
        ENDDO
       ENDDO
C
       NDIM2=ND*2+2+1
C
C	PRINT *,'TFIT7: MAKING MATRIX'
C---- Making Matrix
C
       NDATA=0
       DO I=1,NPOINT
        IF (IDX1(I)) THEN
         NDATA=NDATA+1
         X(NDATA,1)=F(I,1)
         X(NDATA,2)=F(I,2)
         DO J=1,ND
          J1=J*2+1
          J2=M1(J)*2+1
          X(NDATA,J1)=F(I,J2)
          J1=J1+1
          J2=J2+1
          X(NDATA,J1)=F(I,J2)
         ENDDO
         X(NDATA,NDIM2)=DAT(I)
        ENDIF
       ENDDO
C      WRITE (*,*) " Before HH"
C      CALL OUTXD(NMAX,MAXF+1,NDATA,NDIM2,1,1,X)
C
C	PRINT *,'TFIT7: CALLING HOUSEHOLDER'
C---- Calling HouseHolder
C
       DO I=1,NDIM2
        CALL HOUSEV(X,NDATA,NDIM2,I,I) 
       ENDDO
       DN=FLOAT(NDATA)
C      WRITE (*,*) " After  HH"
C      CALL OUTXD(NMAX,MAXF+1,NDATA,NDIM2,1,1,X)
C      WRITE (*,*)
C
C	PRINT *,'TFIT7: CALCULATING VARIANCES AND AIC'
C---- Calc. Variances & AIC
C
       SIGMA2=0.0
       AIC=0.0
       VAL=X(NDIM2,NDIM2)
       SUM=VAL*VAL
       DO I=ND,1,-1
        IF (I.NE.ND) THEN
         II=2*I+2
         VAL1=X(II+1,NDIM2)
         VAL2=X(II+2,NDIM2)
         SUM=SUM+VAL1*VAL1+VAL2*VAL2
        ENDIF
        SIGMA2=SUM/DN
        IF (SIGMA2.LE.1.0D-20) GOTO 3555
        AIC=DN*DLOG(2.0D0*PI*SUM/DN)
     1     +DN
     2     +DFLOAT(4*I+6)
        IF (AIC.LT.AICMIN) THEN
         AICMIN=AIC
         NAICMIN=I
         NAIC=2*NAICMIN+2
         NORDER=M1(ND) 
C        WRITE (*,*) 'NORDER',NORDER
         DO IX=1,ND
          M2(IX)=M1(IX)
         ENDDO
         DO IX=ND+1,MAXF
          M1(IX)=0
         ENDDO
         DO JX=1,NAIC
          DO JY=1,NAIC
           TINV(JX,JY)=X(JX,JY)
          ENDDO
          VEC(JX)=X(JX,NDIM2)
         ENDDO
C        WRITE (*,*) I,SIGMA2,AIC,(M1(IX),IX=1,I)
C        CALL OUTXD(MAXF,MAXF,NAIC,NAIC,1,1,TINV)
C        WRITE (*,*)
        ENDIF
 3555   CONTINUE
C       WRITE (*,*) I,SIGMA2,AIC
C       CALL OUTXD(MAXF,MAXF,NAIC,NAIC,1,1,TINV)
C       WRITE (*,*)
       ENDDO
C
       ND=ND-1
       MF(ND+1)=MF(ND+1)+1
C
C	PRINT *,'TFIT7: END OF LOOP'
C---- End of Loop
C
      IF (ND.GT.0) GOTO 1000
C
C     WRITE (*,*) "NAIC    : ",NAIC
C     WRITE (*,*) "NAICMIN : ",NAICMIN
C     WRITE (*,*) "AICMIN  : ", AICMIN
C     WRITE (*,*) "  MF    : ", (M2(I),I=1,NAICMIN)
C     CALL OUTXD(MAXF,MAXF,NAIC,NAIC,1,1,TINV)
C
C	PRINT *,'TFIT7: MATRIX INVERSION'
C---- Matrix Inversion
C
C     WRITE (*,*) "****** TFIT7 *******",NAIC,AICMIN
      CALL MATINV(TINV,K0,NAIC,EPS,MAXF,DETT,ILL)
C     CALL LUINV(TINV, NAIC, EPS, ILL)
      IF (ILL.NE.0) GOTO 8000
C     CALL OUTXD(MAXF,MAXF,NAIC,NAIC,1,1,TINV)
C
C     DO I=1,NAIC
C      WRITE (*,*) I,VEC(I)
C     ENDDO
C     WRITE (*,*)
C
C	PRINT *,'TFIT7: CALCULATION OF COEFFICIENTS'
C---- Calc. of Coefficients
C
      CMAX=-10.0
      DO I=0,NAICMIN
       SUM1=0.0
       SUM2=0.0
       I1=I*2+1
       IF (I.GT.0) THEN
        I2=M2(I)*2+1
       ELSE
        I2=1
       ENDIF
       DO J=1,NAIC
        SUM1=SUM1+TINV(I1,J)*VEC(J)
        SUM2=SUM2+TINV(I1+1,J)*VEC(J)
       ENDDO
       C(I2)=SUM1
       C(I2+1)=SUM2
       CMAX=MAX(DABS(SUM1),CMAX)
       CMAX=MAX(DABS(SUM2),CMAX)
      ENDDO
C     WRITE (*,*)
C     DO I=1,NDIM0
C      WRITE (*,*) I,C(I)
C     ENDDO
C
C	PRINT *,'TFIT7: CALCULATION OF THEORETICAL VALUE'
C---- Calc. theoretical value
C
      VMIN=9.0D9
      VMAX=-9.0D9
      DO I=1,NPOINT
       SUM=0.0
       DO K=1,NAIC
        SUM=SUM+C(K)*F(I,K)
       ENDDO
       VFIT(I)=SUM
       VMIN=MIN(VMIN,SUM)
       VMAX=MAX(VMAX,SUM)
C      WRITE (*,9010) I,DAT(I),VFIT(I),DAT(I)-VFIT(I)
      ENDDO
C
      IF (VMIN.LT.0.0) GOTO 8000
      IF (VMAX.GT.1.0) GOTO 8000
C     IF (CMAX.GT.1.0) GOTO 8000
C
      RETURN
 8000 CONTINUE
      IF (NORDER.LE.1) GOTO 8100
C
      NORDER=NORDER-1
      GOTO 5555
C
 8100 CONTINUE
      DO I=1,NDIM0
       C(I)=0.0
      ENDDO
      DO I=1,NPOINT
       VFIT(I)=-1.0
      ENDDO
      NORDER=-1
      RETURN
      STOP
C	PRINT *,'TFIT7: END'
C
 9000 FORMAT (2X,I3,15(",",F8.2),",",F8.2)
 9010 FORMAT (2X,I3,",",F10.4,",",F10.4,",",F10.4)
      END
