C
C  tfit3.f
C
C  Triangular Function Fitting
C
C---+-^--1----+----2----+----3----+----4----+----5----+----6----+----7-
C
      SUBROUTINE TFIT3(NPOINT,NFUNC,DAT,IDX1,F,C,VFIT)
      IMPLICIT REAL*8 (A-H,O-Z)
C
      LOGICAL*1 IDX1
C
      PARAMETER(NMAX=250)
      PARAMETER(MAXF=50)
C
      DIMENSION DAT(NMAX)
      DIMENSION IDX1(NMAX)
      DIMENSION F(NMAX,MAXF)
      DIMENSION VFIT(NMAX)
      DIMENSION C(MAXF)
C
      DIMENSION TF(MAXF,MAXF)
      DIMENSION TINV(MAXF,MAXF)
      DIMENSION VEC(MAXF)
C
      EPS=1.0D-10
      NN=NFUNC*2+2
C
C---- Value Initialization
C
      DO I=1,NN
       C(I)=0.0
      ENDDO
      DO I=1,NPOINT
       VFIT(I)=0.0
      ENDDO
C
C---- Matrix Initialization
C
      DO I=1,NN
       DO J=I,NN
        TF(I,J)=0.0
        TF(J,I)=0.0
       ENDDO
       VEC(I)=0.0
      ENDDO
C
C---- Making Matrix
C
      DO I=1,NPOINT
       IF (IDX1(I)) THEN
        DO K1=1,NN
         DO K2=1,NN
          TF(K1,K2)=TF(K1,K2)+F(I,K2)*F(I,K1)
         ENDDO
         VEC(K1)=VEC(K1)+DAT(I)*F(I,K1)
        ENDDO
       ENDIF
      ENDDO
C
C---- Matrix Copy and Inversion
C
      DO I=1,NN
       DO J=I,NN
        TFIJ=TF(I,J)
        TINV(I,J)=TFIJ
        TINV(J,I)=TFIJ
       ENDDO
      ENDDO
C
      CALL MATINV(TINV,K0,NN,EPS,MAXF,DETT,ILL)
C     CALL MATINV(TINV,K0,NN,EPS,DETT,ILL)
C     CALL LUINV(TINV, NN, EPS, ILL)
      IF (ILL.NE.0) GOTO 8000
C
C---- Calc. of Coefficients
C
      CMAX=-10.0
      DO I=1,NN
       SUM=0.0
       DO J=1,NN
        SUM=SUM+TINV(I,J)*VEC(J)
       ENDDO
       C(I)=SUM
       CMAX=MAX(DABS(SUM),CMAX)
      ENDDO
C
C---- Calc. theoretical value
C
      VMIN=9.0D9
      VMAX=-9.0D9
      DO I=1,NPOINT
       SUM=0.0
       DO K=1,NN
        SUM=SUM+C(K)*F(I,K)
       ENDDO
       VFIT(I)=SUM
       VMIN=MIN(VMIN,SUM)
       VMAX=MAX(VMAX,SUM)
      ENDDO
C
      RETURN
 8000 CONTINUE
      DO I=1,NN
       C(I)=0.0
      ENDDO
      DO I=1,NPOINT
       VFIT(I)=DAT(I)
      ENDDO
      RETURN
      STOP
C
C9000 FORMAT (2X,I3,6(",",F8.2),",",F8.2)
C9010 FORMAT (2X,I3,",",F10.4,",",F10.4,",",F10.4)
      END
