C
C  mkmat2.f
C
C  Making Triangular Function Matrix/Vector
C
C---+-^--1----+----2----+----3----+----4----+----5----+----6----+----7-
C
      SUBROUTINE MKMAT2(N,NPOINT,NFUNC,NUMK,F)
      IMPLICIT REAL*8 (A-H,O-Z)
      PARAMETER(NMAX=200)
      PARAMETER(MAXF=50)
C
      DIMENSION F(NMAX,MAXF)
      DIMENSION NUMK(MAXF)
C
      NN=2*NFUNC+2
C
      EPS=1.0D-20
C---- Set Constants
      PI=4.0D0*ATAN(1.0D0)
      VN=DFLOAT(NPOINT)
      ANGLE=2.0D0*PI/VN
C---- Matrix Clear
C     DO I=1,N
C      DO J=1,NN
C       F(I,J)=0.0
C      ENDDO
C     ENDDO
C---- Making Matrix
      DO I=1,N
       DI=DFLOAT(I)
       DO J=1,NFUNC
        J1=J*2+1
        J2=J1+1
        DK=DFLOAT(NUMK(J))
        THETA=ANGLE*DI*DK
        F(I,J1)=SIN(THETA)
        F(I,J2)=COS(THETA)
       ENDDO
       F(I,1)=1.0D0
       F(I,2)=1.0D-1*DFLOAT(I)
C      WRITE (*,9000) I,(F(I,J),J=1,NN)
      ENDDO
C
      RETURN
      STOP
 9000 FORMAT (I4,1X,13(F6.3))
      END
