      SUBROUTINE MATINV (A, K0, M, EPS, ISIZE, DET, ILL)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C----------------------------------------------------------
C     INVERSE AND DETERMINANT OF A BY THE GAUSS-JORDAN METHOD.
C     M IS THE ORDER OF THE SQUARE MATRIX, A.
C     A-INVERSE REPLACES A.
C     DETERMINANT OF A IS PLACED IN DET.
C     COOLEY AND LOHNES (1971:63)
C-----------------------------------------------------------
      PARAMETER (IDIM=50)
      DIMENSION A(ISIZE,ISIZE),IPVT(IDIM+2),PVT(IDIM+2),IND(IDIM+2,2)
      DET=.1D1
      DO 10 J=1,M
   10 IPVT(J)=0
      DO 100 I=1,M
C        SEARCH FOR THE PIVOT ELEMENT
         AMAX=.0D0
           DO 40 J=1,M
              IF(IPVT(J).EQ.1)GO TO 40
           DO 30 K=1,M
              IF(IPVT(K)-1)20,30,130
   20         IF(DABS(AMAX).GE.DABS(A(J,K)))GO TO 30
                     IROW=J
              ICOL=K
              AMAX=A(J,K)
   30      CONTINUE
   40   CONTINUE
         IPVT(ICOL)=IPVT(ICOL)+1
C        INTERCHANGE THE ROWS TO PUT THE PIVOT ELEMENT ON THE DIAGONAL
         IF(IROW.EQ.ICOL)GO TO 60
         DET=-DET
           DO 50 L=1,M
              SWAP=A(IROW,L)
              A(IROW,L)=A(ICOL,L)
   50      A(ICOL,L)=SWAP
   60    IND(I,1)=IROW
         IND(I,2)=ICOL
         PVT(I)=A(ICOL,ICOL)
C        DIVIDE THE PIVOT ROW BY THE PIVOT ELEMENT
         A(ICOL,ICOL)=.1D1
           DO 70 L=1,M
             A(ICOL,L)=A(ICOL,L)/PVT(I)
   70      CONTINUE
C       REDUCE THE NON-PIVOT ROWS
      DO 100 L1=1,M
          IF(L1.EQ.ICOL)GO TO 90
         SWAP=A(L1,ICOL)
         A(L1,ICOL)=.0D0
         IF(SWAP.LT..1D-30.AND.SWAP.GT.-.1D-30)SWAP=.0D0
           DO 80 L=1,M
              A(L1,L)=A(L1,L)-A(ICOL,L)*SWAP
   80      CONTINUE
   90  CONTINUE
  100 CONTINUE
C     INTERCHANGE THE COLUMNS
           DO 120 I=1,M
              L=M+1-I
              IF(IND(L,1).EQ.IND(L,2))GO TO 120
              IROW=IND(L,1)
              ICOL=IND(L,2)
                DO 110 K=1,M
                   SWAP=A(K,IROW)
                   A(K,IROW)=A(K,ICOL)
                   A(K,ICOL)=SWAP
  110           CONTINUE
  120      CONTINUE
  130 CONTINUE
      RETURN
      END
