      PROGRAM LMFSPOTP
C---+----1----+----2----+----3----+----4----+----5----+----6----+----7-|
************************************************************************
***** Triangular Function Fitting  for Time-Series DATA          *******
*****                                                            *******
*****               BSQ to BSQ                                   *******
*****                                                            *******
*****                                     Version III            *******
*****       for Origin 2000                                      *******
*****                                                            *******
*****                                                            *******
*****                             Powered by Yoshito Sawada,2000 *******
*****                Special Thanks to Dr. Sawada,               *******
*****                         Mr. H. Saito and Mr. Mitsuzuka     *******
*****                                                            *******
*****                                     : Aug. 16 '00          *******
*****                           modified  : Sep. 05 '00          *******
*****                           modified  : Feb. 05 '00          *******
***** BETA VERSION *****************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      INTEGER*2 KPIX,MSK,NORD,VALMAX,VALMIN
      INTEGER*2 KPIXP,MSKP
      INTEGER*2 MDEF
      INTEGER*1 SELECT,FITSW,FITMD
      CHARACTER*80 LINE1
      LOGICAL*1 L1,L2,L0
      LOGICAL*1 IDX1
      PARAMETER(MAXB=200)
      PARAMETER(NMAX=MAXB)
      PARAMETER(MAXF=50)
C---- pixel data
      DIMENSION KPIX(MAXB,7500)
      DIMENSION MSK(MAXB,7500)
      DIMENSION PIX(MAXB,7500)
      DIMENSION PIX0(MAXB,7500)
      DIMENSION PARA(MAXB,7500)
C---- for fitting
      DIMENSION KPIXP(MAXB)
      DIMENSION MSKP(MAXB)
      DIMENSION PIXP(MAXB)
      DIMENSION PIX0P(MAXB)
      DIMENSION PARAP(MAXB)
C
      DIMENSION MDEF(NMAX)
      DIMENSION NUMK(MAXF)
      DIMENSION F(NMAX,MAXF)
C---- for AIC
      DIMENSION NORD(7500)
      DIMENSION AIC(7500)
C---- for min/max
      DIMENSION VALMAX(7500)
      DIMENSION VALMIN(7500)
C
      DATA NUMK/  1,  2,  3,  4,  6, 12,  0,  0,  0,  0,
     1            0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     2            0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3            0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     4            0,  0,  0,  0,  0,  0,  0,  0,  0,  0/
C---+----1----+----2----+----3----+----4----+----5----+----6----+----7-|
      NAMELIST/DATA/NDAT,NFUNC,NDEF,ISPOT
      NAMELIST/CONTRL/NWIN,INTP,SELECT,MMSW,TCLD,FITSW,MASK,FITMD
      NAMELIST/NPT/NPOINT
C     NAMELIST/ITER/MAXIT
C
C---- Set Defaults
C
      NFUNC=6
      NWIN=3
      NDS=14
      INTP=0
      SELECT=1
      MMSW=1
      TCLD=0.15
      NDEF=0
      FITSW=1
      MAXIT=0
      ISPOT=0
      MASK=0
C---- # it tries to access a mask file when mask=1
      FITMD=0
C
      NITER=0
C
      PI=ATAN(1.0D0)*4.0D0
      VNULL=-9.9D1
C
C---- # of data/year
C
      NPOINT=46
C
C	PRINT *, 'OPEN CNTL.DAT'
      OPEN(15,FILE='cntl.dat')
C
	PRINT *, 'READ CNTL.DAT'
      READ (15,*) NBANDS
      READ (15,*) NLINS,NCOLS
      READ (15,NML=DATA)
      READ (15,NML=CONTRL)
C	print *,'NPOINT=', NPOINT
      READ (15,NML=NPT)
C	print *,'NPOINT=', NPOINT
C
      IF (NDEF.GT.0.AND.NDEF.LE.NBANDS) THEN
       WRITE (*,*) '----'
       WRITE (*,*) NDEF
C      READ (15,*) LINE1
       IX=0
       DO I=1,NDEF
        READ (15,*) II
        IF (II.GT.0.AND.II.LE.NBANDS) THEN
         IX=IX+1
         WRITE (*,*) IX,II
         MDEF(IX)=II
        ENDIF
       ENDDO
       WRITE (*,*) '----'
      ENDIF
C
	PRINT *, 'CLOSE CNTL.DAT'
      CLOSE (15)
C
      NDAT=NBANDS
      IF (NBANDS.LT.3.OR.NBANDS.GT.MAXB) STOP
      IF (NDEF.LT.0.OR.NDEF.GT.NBANDS) STOP
C
      NNB=NBANDS+2
C
      NDS=2*NFUNC+2
      MWIN=2*NWIN+1
      THH=TCLD*2.0
      THL=-TCLD
      IF (FITMD.EQ.1) THEN
       THH=TCLD
       THL=-TCLD*2.0
      ELSEIF (FITMD.EQ.2) THEN
       THH=TCLD
       THL=-TCLD
      ENDIF
	PRINT *, 'MAKING FUNCTION MATRIX'
C
C---- Making Function Matrix
C
      CALL MKMAT2(NBANDS,NPOINT,NFUNC,NUMK,F)
C
************************************************************************
	print *, 'opening data bsq'
C      OPEN(21,FILE='data.bsq',RECL=2,ACCESS='DIRECT')
      OPEN(21,FILE='data.bsq',RECL=2,ACCESS='DIRECT',
     + FORM='BINARY')
C    	print *, 'opened'
C      IF (MASK.EQ.1) OPEN(22,FILE='mask.bsq',RECL=1,ACCESS='DIRECT')
      IF (MASK.EQ.1) OPEN(22,FILE='mask.bsq',RECL=1,ACCESS='DIRECT',
     + FORM='BINARY')
C
C      OPEN(50,FILE='p.bsq',RECL=4,ACCESS='DIRECT')
      OPEN(50,FILE='p.bsq',RECL=4,ACCESS='DIRECT',
     + FORM='BINARY')
C
      IF (INTP.EQ.1) THEN
C       OPEN(51,FILE='i.bsq',RECL=2,ACCESS='DIRECT')
       OPEN(51,FILE='i.bsq',RECL=2,ACCESS='DIRECT',
     + FORM='BINARY')
      ENDIF
C      OPEN(52,FILE='f.bsq',RECL=2,ACCESS='DIRECT',
      OPEN(52,FILE='f.bsq',RECL=2,ACCESS='DIRECT',
     + FORM='BINARY')
C      OPEN(54,FILE='order.dat',RECL=1,ACCESS='DIRECT')
      OPEN(54,FILE='order.dat',RECL=1,ACCESS='DIRECT',
     + FORM='BINARY')
C      OPEN(55,FILE='aic.dat',RECL=4,ACCESS='DIRECT')
      OPEN(55,FILE='aic.dat',RECL=4,ACCESS='DIRECT',
     + FORM='BINARY')
C      OPEN(61,FILE='min.dat',RECL=2,ACCESS='DIRECT')
      OPEN(61,FILE='min.dat',RECL=2,ACCESS='DIRECT',
     + FORM='BINARY')
C      OPEN(62,FILE='max.dat',RECL=2,ACCESS='DIRECT')
      OPEN(62,FILE='max.dat',RECL=2,ACCESS='DIRECT',
     + FORM='BINARY')
C
C---- Loop
C
	PRINT *, 'MAKING FUNCTION MATRIX LOOP'

      DO INPAR=1,NLINS
C
C	PRINT *, 'CALL GTBQ2F'
C	PRINT *, 'NLINS', NLINS, 'NCOLS', NCOLS
C	PRINT *, 'NBANDS', NBANDS
C     print *, NLINS,NCOLS,1,NBANDS
      write(*,'(1h ,i5,1h/,i5, 4hline)') inpar, nlins
       CALL GTBQ2F(INPAR,NLINS,NCOLS,1,NBANDS,KPIX,21)
C
C	PRINT *, 'CALL GTBQ1F'       
       IF (MASK.EQ.1) THEN
        CALL GTBQ1F(INPAR,NLINS,NCOLS,1,NBANDS,MSK,22)
       ENDIF

       
C	PRINT *, 'START PARALLEL'
C
C  in  :  KPIX(K,J)
C  out :  PIX(K,J)
C
C---+----1----+----2----+----3----+----4----+----5----+----6----+----7-|
!$OMP  PARALLEL
!$OMP& SHARED(NLINS,NCOLS,INPAR),
!$OMP& SHARED(NBANDS,NFUNC,NDS,NWIN,NDEF),
!$OMP& SHARED(MMSW,INTP,THL,THH,FITSW,VNULL,MAXIT,MASK),
!$OMP& SHARED(F,KPIX,PIX0,PIX,MSK,PARA,AIC,NORD,VALMAX,VALMIN),
!$OMP& DEFAULT(PRIVATE)
C       NTH = OMP_GET_NUM_THREADS()
C       IAM = OMP_GET_THREAD_NUM()
       NTH = 1
       IAM = 0
       JSTART = IAM+1
C
       DO J=JSTART,NCOLS,NTH
C
C---- Calling the columns
C	PRINT *,'PARALLEL:DO COLS',JSTART,' TO',NCOLS,' STEPS',NTH
C
C---- Pre Processing
C
        DO K=1,NBANDS
         KPIXP(K)=KPIX(K,J)
         MSKP(K)=1
         IF (MASK.EQ.1) MSKP(K)=MSK(K,J)
        ENDDO
C
C
C	PRINT *, 'PARALLEL: CALL LMF PROCESS START'
C---- CALL LMF Process
C
C---+----1----+----2----+----3----+----4----+----5----+----6----+----7-|
        CALL LMFPROS(NBANDS,NFUNC,KPIXP,PIXP,PIX0P,MSKP,PARAP,F,NDS,
     1               NWIN,MAXP,MINP,NDEF,MDEF,AICP,NORDP,MMSW,INTP,
     2               THL,THH,FITSW,VNULL,MAXIT,MASK,FITMD)
C
C	PRINT *, 'PARALLEL: CALL LMF PROCESS END'

C---- Post Processing
C
        DO K=1,NBANDS
         PIX0(K,J)=PIX0P(K)
         PIX(K,J)=PIXP(K)
        ENDDO
        DO K=1,NDS
         PARA(K,J)=PARAP(K)
        ENDDO
        AIC(J)=AICP
        NORD(J)=NORDP
        VALMAX(J)=MAXP
        VALMIN(J)=MINP
C
       ENDDO
C
!$OMP  END PARALLEL
C	PRINT *, 'END PARALLEL'
C
       CALL PUTBSQ4(INPAR,NLINS,NCOLS,1,NDS,PARA)
       IF (INTP.EQ.1) THEN
        CALL PUTBSQ2(INPAR,NLINS,NCOLS,1,NBANDS,PIX0,51,0)
       ENDIF
       CALL PUTBSQ2(INPAR,NLINS,NCOLS,1,NBANDS,PIX,52,0)
       CALL PUTDAT1(INPAR,NCOLS,NORD,54)
       CALL PUTDATF(INPAR,NCOLS,AIC,55)
       CALL PUTDAT1(INPAR,NCOLS,VALMIN,61)
       CALL PUTDAT1(INPAR,NCOLS,VALMAX,62)
      ENDDO
C
C---- Termination Procedure
C
      CLOSE(21)
      IF (MASK.EQ.1) THEN
       CLOSE(22)
      ENDIF
      IF (INTP.EQ.1) THEN
       CLOSE(51)
      ENDIF
      CLOSE(52)
      CLOSE(53)
      CLOSE(61)
      CLOSE(62)
      CLOSE(63)
 8880 CONTINUE
      WRITE (*,*) "Program Deadified"
C
      STOP
C
 9000 FORMAT (I3,1X,I3,1X,A3)
 9010 FORMAT (A3,I3,1X,I3,1X)
 9500 FORMAT(5X,I5,3(2X,F12.6))
 9510 FORMAT(D20.14,3(3X,D20.14))
C
      END
