      SUBROUTINE LMFPROS(NBANDS,NFUNC,KPIXP,PIXP,PIX0P,MSKP,PARAP,F,NDS,
     1             NWIN,MAXP,MINP,NDEF,MDEF,AICP,NORDP,MMSW,INTP,
     2             THL,THH,FITSW,VNULL,MAXIT,MASK,FITMD)
C
C---+----1----+----2----+----3----+----4----+----5----+----6----+----7-|
************************************************************************
***** Triangular Function Fitting  for Time-Series DATA          *******
*****                                                            *******
*****               BSQ to BSQ                                   *******
*****                                                            *******
*****                                     Version III            *******
*****                                                            *******
*****                             Powered by Yoshito Sawada,2000 *******
*****                Special Thanks to Dr. Sawada,               *******
*****                         Mr. H. Saito and Mr. Mitsuzuka     *******
*****                                                            *******
*****                                     : Aug. 16 '00          *******
*****                           modified  : Sep. 05 '00          *******
*****                           modified  : Feb. 05 '01          *******
***** BETA VERSION *****************************************************
      IMPLICIT REAL*8 (A-H,O-Z)
      INTEGER*2 MSKP,KPIXP
      INTEGER*2 MDEF
      INTEGER*1 SELECT,FITSW,FITMD
      LOGICAL*1 L1,L2,L0
      LOGICAL*1 IDX1
      PARAMETER(MAXB=200)
      PARAMETER(NMAX=MAXB)
      PARAMETER(MAXF=50)
C---- pixel data
      DIMENSION KPIXP(MAXB)
      DIMENSION MSKP(MAXB)
      DIMENSION PIXP(MAXB)
      DIMENSION PIX0P(MAXB)
      DIMENSION PARAP(MAXB)
C---- for fitting
      DIMENSION DAT(NMAX),IDX1(NMAX)
      DIMENSION MDEF(NMAX)
      DIMENSION F(NMAX,MAXF),C(MAXF)
      DIMENSION VFIT(NMAX)
      DIMENSION IPOINT(MAXB)
C---- for iteration
      DIMENSION DAT0(NMAX),C0(MAXF)
      DIMENSION DAT1(NMAX)
C
      PI=3.1415926535897932385
C
C---- Set Defaults
C
      VAL1=0.0
C
C---- LMF Process
C
      NORDP=0
      AICP=-1.0
C
      MNUL=0
      MAXP=0
      MINP=0
      ISW=0
      L0=.TRUE.
C
C----=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
C
      DO K=1,NBANDS
       DAT0(K)=0.0
       PIXP(K)=0
       IPOINT(K)=1
       IDX1(K)=.TRUE.
       L0 = L0.AND.(KPIXP(K).LE.0)
      ENDDO
C
      IF (MASK.NE.1) THEN
       DO K=1,NBANDS
        MSKP(K)=1
       ENDDO
      ENDIF
C
      DO K=1,NDS
       PARAP(K)=0.0
       C(K)=0.0
      ENDDO
C
      IF (NDEF.GT.0) THEN
       DO K=1,NDEF
        KK=MDEF(K)
        IPOINT(KK)=0
        IDX1(KK)=.FALSE.
       ENDDO
      ENDIF
C
C	PRINT *, 'LMFPROS: INITIAL GUESS'

C---- Making Initial Guess
C
      DO K=1,NBANDS
       IF (KPIXP(K).GT.1536) THEN
        IPOINT(K)=0
        MSKP(K)=0
       ENDIF
       IF (K.GE.2) THEN
        IDK=(KPIXP(K)-KPIXP(K-1))
        IF (IDK.GT.512) THEN
         IPOINT(K)=0
         MSKP(K)=0
        ENDIF
       ENDIF
       DAT0(K)=DFLOAT(KPIXP(K))/4096.0
       DAT(K)=DAT0(K)
      ENDDO
C
      IF (MASK.EQ.1) GOTO 2100
C	PRINT *, 'LMFPROS: INTERPOLATION'
C---- Interpolation
      IF (NDEF.GT.0) CALL INTRP(NBANDS,DAT,IPOINT,MNUL)
C	PRINT *, 'LMFPROS: MAXIMUM FILTER'
C---- Minimax Filter
      IF (MMSW.GE.1.AND.FITMD.EQ.0) THEN
       CALL MINMAX(NBANDS,NWIN,DAT)
      ELSEIF (MMSW.GE.1.AND.FITMD.EQ.1) THEN
       CALL MAXMIN(NBANDS,NWIN,DAT)
      ENDIF
C	PRINT *, 'LMFPROS: FITTING'
C---- Fitting
      CALL TFIT3(NBANDS,3,DAT,IDX1,F,C,VFIT)
C
      DO K=1,NBANDS
       DAT1(K)=VFIT(K)
      ENDDO
C
 2000   CONTINUE
C
      NITER=NITER+1
C
      DO K=1,NBANDS
       DELTA=DAT0(K)-VFIT(K)
       DAT(K)=DAT0(K)
       IF (DELTA.LT.THL.OR.DELTA.GT.THH) THEN
        IPOINT(K)=0 
        IDX1(K)=.FALSE.
       ELSE
        IPOINT(K)=1 
        IDX1(K)=.TRUE.
       ENDIF
      ENDDO
C
      DO K=1,NDS
       C0(K)=C(K)
      ENDDO
C
 2100 CONTINUE
C
      IF (NDEF.GT.0) THEN
       DO K=1,NDEF
        KK=MDEF(K)
        IPOINT(KK)=0
        IDX1(KK)=.FALSE.
       ENDDO
      ENDIF
C
C	PRINT *, 'LMFPROS: INTERPOLATION 2'
C---- Interpolation
C
      IF (MASK.EQ.1) THEN
       DO K=1,NBANDS
        IPOINT(K)=MSKP(K)
       ENDDO
      ENDIF
      CALL INTRP(NBANDS,DAT,IPOINT,MNUL)
C
C---- Interpolation Compeleted!
C
      IF (INTP.GE.1) THEN
       DO K=1,NBANDS
        PIX0P(K)=DAT1(K)
       ENDDO
      ENDIF
C
      NORDER=NFUNC
      IF (MNUL.GT.7.AND.NORDER.GT.5) NORDER=5
      IF (MNUL.GT.13.AND.NORDER.GT.4) NORDER=4
      IF (MNUL.GT.19.AND.NORDER.GT.3) NORDER=3
C	PRINT *, 'LMFPROS: MINIMAX FILTER'
C---- Minimax Filter
      IF (MMSW.GE.1.AND.FITMD.EQ.0) THEN
       CALL MINMAX(NBANDS,NWIN,DAT)
      ELSEIF (MMSW.GE.1.AND.FITMD.EQ.1) THEN
       CALL MAXMIN(NBANDS,NWIN,DAT)
      ENDIF
C	PRINT *, 'LMFPROS: CHECKING PIXEL VALUE'
C---- Checking Pixel Value
      IF (FITSW.GT.0) THEN
       DO K=1,NBANDS
        IDX1(K)=.FALSE.
        IF (IPOINT(K).EQ.1) IDX1(K)=.TRUE.
       ENDDO
      ENDIF
C	PRINT *, 'LMFPROS: FITTING 2 START'
C---- Fitting
C	PRINT *,'NBANDS',NBANDS
C	PRINT *,'NFUNC', NFUNC
C	PRINT *,'DAT', DAT
C	PRINT *,'IDX1', IDX1
C	PRINT *,'F', F
C	PRINT *,'C', C
C	PRINT *,'VFIT', VFIT
C	PRINT *,'NORDER', NORDER
C	PRINT *,'VAIC', VAIC
C	PRINT *, NBANDS,NFUNC,DAT,IDX1,F,C,VFIT,NORDER,VAIC
      CALL TFIT7(NBANDS,NFUNC,DAT,IDX1,F,C,VFIT,NORDER,VAIC)
C	PRINT *, 'LMFPROS: FITTING 2 END'
C       WRITE (*,*) (IDX1(K),K=1,NBANDS)
      AICP=VAIC
      NORDP=NORDER
      IF (VAIC.EQ.0.0) GOTO 6990
      IF (NORDER.LE.1) GOTO 6990
C	PRINT *, 'LMFPROS: CALCULATE PROPERTIES'
C---- Calculate Properties
      VMA1=-9.9D9
      VMI1=-VMA1
      DO K=1,NBANDS
       VALUE=VFIT(K)
       PIXP(K)=VALUE
       IF (VMA1.LT.VALUE) VMA1=VALUE
       IF (VMI1.GT.VALUE) VMI1=VALUE
      ENDDO
      IF (VMA1.LT.0.0D1) VMA1=0.0
      IF (VMI1.GT.1.0D1) VMI1=0.0
C	PRINT *, 'LMFPROS: CALCULATE PROPERTIES 2'
C---- Calculate Properties
      PARAP(1)=C(1)
      PARAP(2)=C(2)
      DO K=1,NFUNC
       K1=2*K+1
       K2=K1+1
       V1=C(K1)
       V2=C(K2)
       VNORM=DSQRT(V1*V1+V2*V2)
       IF (VNORM.GT.1.0D-40) THEN
        PARAP(K1)=VNORM
C
        AV1=DABS(V1)
        SV1=DSIGN(1.0D0,V1)
        SV2=DSIGN(1.0D0,V2)
C
        OFFS=0.0
        IF (SV1.LT.0.0.AND.SV2.LT.0.0) OFFS=-PI
        IF (SV1.LT.0.0.AND.SV2.GT.0.0) OFFS=PI
C
        IF (AV1.LT.1.0D-10) THEN
         ANGLE=0.5D0*PI*SV1*SV2
        ELSE
         TN=V2/V1
         ANGLE=ATAN(TN)+OFFS
        ENDIF
        PARAP(K2)=ANGLE
       ELSE
        PARAP(K1)=0.0
        PARAP(K2)=0.0
       ENDIF
      ENDDO
C	PRINT *, 'LMFPROS: CALCULATE RELATIVE GREENNESS'
C---- Calc. Relative Greenness
      MINP=INT(VMI1*4096.0+0.49)
      MAXP=INT(VMA1*4096.0+0.49)
C
C	PRINT *, 'LMFPROS: INTERPOLATION CONTINUED'
C---- for inter. cont.
C
      IF (ISW.EQ.0) GOTO 7000
C
      SUM1=0.0
      DO K=1,NDS
       DELTA=C(K)-C0(K)
       SUM1=SUM1+DELTA*DELTA
      ENDDO
      SUM1=DSQRT(SUM1)/14.0
      IF (SUM1.GT.1.0D-5.AND.MAXIT.GT.NITER) GOTO 2000
      GOTO 7000
C
 6990 CONTINUE
      L1=.FALSE.
      ISUM=0
      DO K=1,NBANDS
       PIXP(K)=0.0
       MSKP(K)=0
      ENDDO
      DO K=1,NDS
       PARAP(K)=0.0
      ENDDO
      MAXP=0
      MINP=0
C
 7000 CONTINUE
C
      DO K=1,NBANDS
       MSKP(K)=0
       IF (IDX1(K)) MSKP(K)=1
      ENDDO
C
C	PRINT *, 'LMFPROS: END'
C---- END of Process
C
      RETURN
C
 9100 FORMAT(I4,3(1X,F8.4))
C9500 FORMAT(5X,I5,3(2X,F12.6))
C9510 FORMAT(D20.14,3(3X,D20.14))
C
      END
