      SUBROUTINE HOUSEV(A,M,N,K,IROW)
C---+----1---+----2---+----3---+----4---+----5---+----6---+----7-|
      IMPLICIT REAL*8 (A-H,O-Z)
C
      PARAMETER (NMAX=200)
      PARAMETER (MAXF=50)
C
      DIMENSION A(NMAX,MAXF)
      DIMENSION B(NMAX,MAXF)
      DIMENSION P(NMAX,NMAX)
      DIMENSION VEC(NMAX)
C
      IF (IROW.LE.0.OR.IROW.GT.N) RETURN
      IF (K.LE.0.OR.K.GT.M) RETURN
      NUM=M
      IF (N.GT.M) NUM=N
C
      DO I=1,NUM
       DO J=I,NUM
        P(I,J)=0.0
        P(J,I)=0.0
       ENDDO
       VEC(I)=0.0
      ENDDO
C
      SUM=0.0
      DO KK1=K,M
       VAL=A(KK1,IROW)
       SUM=SUM+VAL*VAL
       VEC(KK1)=VAL
      ENDDO
      SIGMA=DSQRT(SUM)
      VAL=A(K,IROW)
C
      IF (SIGMA.LT.1.0D-60) RETURN
C
      VSIGN=SIGN(SIGMA,VAL)
      ALPHA=1.0D0/(SUM+VSIGN*VAL)
C
      VEC(K)=VEC(K)+VSIGN
C
      DO KK1=1,M
       DO KK2=KK1,M
        P(KK1,KK2)=-ALPHA*VEC(KK1)*VEC(KK2)
        IF (KK1.NE.KK2) THEN
         P(KK2,KK1)=P(KK1,KK2)
        ELSE
         P(KK1,KK2)=P(KK1,KK2)+1.0D0
        ENDIF
       ENDDO
      ENDDO
C
      DO KK1=1,M
       DO KK2=1,N
        SUM=0.0
        DO KK3=1,M
         SUM=SUM+P(KK1,KK3)*A(KK3,KK2)
        ENDDO
        B(KK1,KK2)=SUM
       ENDDO
      ENDDO
C
      DO KK1=1,M
       DO KK2=1,N
        A(KK1,KK2)=B(KK1,KK2)
       ENDDO
      ENDDO
C
      RETURN
      STOP
      END
